% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsonCodecs.R
\name{bettrToJSON}
\alias{bettrToJSON}
\title{Export SummarizedExperiment to bettr JSON format}
\usage{
bettrToJSON(bettrSE, file = NULL, pretty = TRUE)
}
\arguments{
\item{bettrSE}{A \code{SummarizedExperiment} object created by
\code{assembleSE}.}

\item{file}{Character scalar, path to the output JSON file. If NULL,
returns the JSON string without writing to file.}

\item{pretty}{Logical scalar, whether to format the JSON output with
indentation for readability (default: TRUE).}
}
\value{
If \code{file} is NULL, returns a JSON string. Otherwise, writes
to file and returns the file path invisibly.
}
\description{
Export a bettr SummarizedExperiment object to a standardized JSON format
that can be re-imported using \code{bettrSEFromJSON}.
}
\examples{
df <- data.frame(Method = c("M1", "M2", "M3"),
                 metric1 = c(1, 2, 3),
                 metric2 = c(3, 1, 2))
bettrSE <- assembleSE(df = df)
json_str <- bettrToJSON(bettrSE)

}
\author{
Daniel Incicau
}
