% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestRefEntries.R
\name{TestRefEntries}
\alias{TestRefEntries}
\title{A class for accessing the test reference entries.}
\description{
A class for accessing the test reference entries.

A class for accessing the test reference entries.
}
\details{
The test reference entries are stored as JSON files inside
\code{inst/testref} folder of each extension package.
}
\examples{
# Creates an instance
refEntries <- TestRefEntries$new('comp.sqlite', pkgName='biodb')

# Gets identifiers of all reference entries
refEntries$getAllIds()

# Gets a data frame with the content of the reference entries
refEntries$getAllRefEntriesDf()

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TestRefEntries-new}{\code{TestRefEntries$new()}}
\item \href{#method-TestRefEntries-getAllIds}{\code{TestRefEntries$getAllIds()}}
\item \href{#method-TestRefEntries-getContents}{\code{TestRefEntries$getContents()}}
\item \href{#method-TestRefEntries-getRealEntries}{\code{TestRefEntries$getRealEntries()}}
\item \href{#method-TestRefEntries-saveEntriesAsJson}{\code{TestRefEntries$saveEntriesAsJson()}}
\item \href{#method-TestRefEntries-getRealEntry}{\code{TestRefEntries$getRealEntry()}}
\item \href{#method-TestRefEntries-getRefEntry}{\code{TestRefEntries$getRefEntry()}}
\item \href{#method-TestRefEntries-getAllRefEntriesDf}{\code{TestRefEntries$getAllRefEntriesDf()}}
\item \href{#method-TestRefEntries-clone}{\code{TestRefEntries$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestRefEntries-new"></a>}}
\if{latex}{\out{\hypertarget{method-TestRefEntries-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestRefEntries$new(db.class, pkgName, folder = NULL, bdb = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db.class}}{Identifier of the database.}

\item{\code{pkgName}}{Name of the package in which are stored the reference
entry files.}

\item{\code{folder}}{The folder where to find test reference files for the package.
Usually it is "inst/testref".}

\item{\code{bdb}}{A valid BiodbMain instance or NULL.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestRefEntries-getAllIds"></a>}}
\if{latex}{\out{\hypertarget{method-TestRefEntries-getAllIds}{}}}
\subsection{Method \code{getAllIds()}}{
Retrieve all identifiers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestRefEntries$getAllIds(limit = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limit}}{The maximum number of identifiers to return.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector containing the IDs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestRefEntries-getContents"></a>}}
\if{latex}{\out{\hypertarget{method-TestRefEntries-getContents}{}}}
\subsection{Method \code{getContents()}}{
Get the reference contents for the specfied IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestRefEntries$getContents(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{The reference IDs for which to get the contents.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestRefEntries-getRealEntries"></a>}}
\if{latex}{\out{\hypertarget{method-TestRefEntries-getRealEntries}{}}}
\subsection{Method \code{getRealEntries()}}{
Retrieve all real entries from database corresponding to the reference
entris.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestRefEntries$getRealEntries(ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{A character vector of entry identifiers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list containing BiodbEntry instances.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestRefEntries-saveEntriesAsJson"></a>}}
\if{latex}{\out{\hypertarget{method-TestRefEntries-saveEntriesAsJson}{}}}
\subsection{Method \code{saveEntriesAsJson()}}{
Saves a list of entries into separate JSON files, inside the test output
folder.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestRefEntries$saveEntriesAsJson(ids, entries)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{The IDs of the entries.}

\item{\code{entries}}{A list of entries. It can contain NULL values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestRefEntries-getRealEntry"></a>}}
\if{latex}{\out{\hypertarget{method-TestRefEntries-getRealEntry}{}}}
\subsection{Method \code{getRealEntry()}}{
Retrieves one real entry from database corresponding to one reference
entry.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestRefEntries$getRealEntry(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The identifier of the entry.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A BiodbEntry instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestRefEntries-getRefEntry"></a>}}
\if{latex}{\out{\hypertarget{method-TestRefEntries-getRefEntry}{}}}
\subsection{Method \code{getRefEntry()}}{
Retrieves the content of a single reference entry.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestRefEntries$getRefEntry(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The identifier of the reference entry to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The content of the reference entry as a list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestRefEntries-getAllRefEntriesDf"></a>}}
\if{latex}{\out{\hypertarget{method-TestRefEntries-getAllRefEntriesDf}{}}}
\subsection{Method \code{getAllRefEntriesDf()}}{
Load all reference entries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestRefEntries$getAllRefEntriesDf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data frame containing all the reference entries with their values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestRefEntries-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TestRefEntries-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestRefEntries$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
