% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biotmle.R
\name{biomarkertmle}
\alias{biomarkertmle}
\title{Biomarker Evaluation with Targeted Minimum Loss Estimation of the ATE}
\usage{
biomarkertmle(
  se,
  varInt,
  normalized = TRUE,
  ngscounts = FALSE,
  bppar_type = BiocParallel::MulticoreParam(),
  bppar_debug = FALSE,
  cv_folds = 1,
  g_lib = c("SL.mean", "SL.glm", "SL.bayesglm"),
  Q_lib = c("SL.mean", "SL.bayesglm", "SL.earth", "SL.ranger"),
  ...
)
}
\arguments{
\item{se}{A \code{SummarizedExperiment} containing microarray expression
or next-generation sequencing data in the \code{assays} slot and a matrix
of phenotype-level data in the \code{colData} slot.}

\item{varInt}{A \code{numeric} indicating the column of the design matrix
corresponding to the treatment or outcome of interest (in the
\code{colData} slot of the \code{SummarizedExperiment} argument "se").}

\item{normalized}{A \code{logical} indicating whether the data included in
the \code{assay} slot of the input \code{SummarizedExperiment} object has
been normalized externally. The default is set to \code{TRUE} with the
expectation that an appropriate normalization method has been applied. If
set to \code{FALSE}, median normalization is performed for microarray data.}

\item{ngscounts}{A \code{logical} indicating whether the data are counts
generated from a next-generation sequencing experiment (e.g., RNA-seq). The
default setting assumes continuous expression measures as generated by
microarray platforms.}

\item{bppar_type}{A parallelization option specified by \code{BiocParallel}.
Consult the manual page for \code{\link[BiocParallel]{BiocParallelParam}}
for possible types and their descriptions. The default for this argument is
\code{\link[BiocParallel]{MulticoreParam}}, for multicore evaluation.}

\item{bppar_debug}{A \code{logical} indicating whether or not to rely upon
pkg{BiocParallel}. Setting this argument to \code{TRUE}, replaces the call
to \code{\link[BiocParallel]{bplapply}} by a call to \code{lapply}, which
significantly reduces the overhead of debugging. Note that invoking this
option overrides all other parallelization arguments.}

\item{cv_folds}{A \code{numeric} scalar indicating how many folds to use in
performing targeted minimum loss estimation. Cross-validated estimates have
been demonstrated to allow relaxation of certain theoretical conditions and
and accommodate the construction of more conservative variance estimates.}

\item{g_lib}{A \code{character} vector specifying the library of machine
learning algorithms for use in fitting the propensity score P(A = a | W).}

\item{Q_lib}{A \code{character} vector specifying the library of machine
learning algorithms for use in fitting the outcome regression E[Y | A,W].}

\item{...}{Additional arguments to be passed to \code{\link[drtmle]{drtmle}}
in computing the targeted minimum loss estimator of the average treatment
effect.}
}
\value{
S4 object of class \code{biotmle}, inheriting from
 \code{SummarizedExperiment}, with additional slots \code{tmleOut} and
 \code{call}, among others, containing TML estimates of the ATE of exposure
 on biomarker expression.
}
\description{
Computes the causal target parameter defined as the difference between the
biomarker expression values under treatment and those same values under no
treatment, using Targeted Minimum Loss Estimation.
}
\examples{
library(dplyr)
library(biotmleData)
library(SuperLearner)
library(SummarizedExperiment)
data(illuminaData)

colData(illuminaData) <- colData(illuminaData) \%>\%
  data.frame() \%>\%
  mutate(age = as.numeric(age > median(age))) \%>\%
  DataFrame()
benz_idx <- which(names(colData(illuminaData)) \%in\% "benzene")

biomarkerTMLEout <- biomarkertmle(
  se = illuminaData[1:2, ],
  varInt = benz_idx,
  bppar_type = BiocParallel::SerialParam(),
  g_lib = c("SL.mean", "SL.glm"),
  Q_lib = c("SL.mean", "SL.glm")
)
}
