% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binCoverage.R
\name{binCoverage}
\alias{binCoverage}
\title{Bin CpG or CpH coverage to simplify and improve CNA "sketching"}
\usage{
binCoverage(
  bsseq,
  bins,
  which = NULL,
  QDNAseq = TRUE,
  readLen = 100,
  paired = TRUE
)
}
\arguments{
\item{bsseq}{A bsseq object - supplied to getCoverage()}

\item{bins}{Bins to summarize over - from tileGenome or QDNAseq.xxYY}

\item{which}{Limit to specific regions? - functions as an import()
(DEFAULT: NULL)}

\item{QDNAseq}{Return a QDNAseqReadCounts? - if FALSE, returns a GRanges
(DEFAULT: TRUE)}

\item{readLen}{Correction factor for coverage - read length in bp
(DEFAULT: 100)}

\item{paired}{Whether the data are from paired-end sequencing
(DEFAULT: TRUE)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{    Binned read counts
}\if{html}{\out{</div>}}
}
\description{
Example usage for E-M
}
\details{
NOTE: As of early Sept 2019, QDNAseq did not have hg38 capabilities. If you
desire to use the hg38 genome, biscuiteer suggests you use a GRanges object
to define your bins.

NOTE: As of late July 2020, biscuiteer has started implemented support for
hg38, hg19, mm10, and mm9 for bisulfite-specific features, including
adaptive GC-content computation and SV integration for adjusting CNV ends.
}
\examples{

  bins <- GRanges(seqnames = rep("chr11",10),
                  strand = rep("*",10),
                  ranges = IRanges(start=100000*0:9, width=100000)
                 )

  reg <- GRanges(seqnames = rep("chr11",5),
                 strand = rep("*",5),
                 ranges = IRanges(start = c(0,2.8e6,1.17e7,1.38e7,1.69e7),
                                  end= c(2.8e6,1.17e7,1.38e7,1.69e7,2.2e7))
                 )

  orig_bed <- system.file("extdata", "MCF7_Cunha_chr11p15.bed.gz",
                          package="biscuiteer")
  orig_vcf <- system.file("extdata", "MCF7_Cunha_header_only.vcf.gz",
                          package="biscuiteer")
  bisc <- readBiscuit(BEDfile = orig_bed, VCFfile = orig_vcf,
                      merged = FALSE)

  bc <- binCoverage(bsseq = bisc, bins = bins, which = reg, QDNAseq = FALSE)

}
