% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getClock.R
\name{getClock}
\alias{getClock}
\title{Retrieve 'epigenetic clock' models}
\usage{
getClock(
  model = c("horvath", "horvathshrunk", "hannum", "skinandblood"),
  padding = 15,
  genome = c("hg19", "hg38", "GRCh37", "GRCh38"),
  useENSR = FALSE,
  useHMMI = FALSE
)
}
\arguments{
\item{model}{One of "horvath", "horvathshrunk", "hannum", or
"skinandblood"}

\item{padding}{How many base pairs (+/-) to expand a feature's footprint
(DEFAULT: 15)}

\item{genome}{One of "hg19", "GRCh37", "hg38", or "GRCh38"
(DEFAULT: "hg19")}

\item{useENSR}{Substitute ENSEMBL regulatory feature boundaries?
(DEFAULT: FALSE)}

\item{useHMMI}{Substitute HMM-based CpG island boundaries?
(DEFAULT: FALSE)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{    a List with elements `model`, `gr`, `intercept`,
              and `cleanup`
}\if{html}{\out{</div>}}
}
\description{
Biscuiteer supports several 'epigenetic clock' models. This function
retrieves the various models.
}
\details{
The remapped coordinates for the Horvath (2012) and Hannum (2013) clocks,
along with shrunken Horvath (2012) and improved Horvath (2018) models, are
provided as part of biscuiteer (visit inst/scripts/clocks.R to find out how)
along with some functionality to make them more usable in RRBS/WGBS data of
varying coverage along varying genomes. For example, the HMM-based CpG island
model introduced by Wu (2010) can be used to assign to within-island features
the methylation rate of their associated island, and ENSEMBL regulatory build
features (ENSR features, for short) such as CTCF binding sites can have their
coordinates substituted for the default padded boundaries of a feature.

The net result of this process is that, while the default settings simply
swap in a 30-bp stretch centered on the selected clock's CpG (and/or CpH)
loci, add the intercept, and ship out the model, much more flexibility is
available to the user. This function provides a single point for tuning of
such options in the event that defaults don't work well for a user.

The precedence of options is as follows:
\enumerate{
\item If a feature has neither ENSR nor HMMI IDs, it is padded
(only) +/- bp.
\item If it has an HMMI but not ENSR ID or ENSR==FALSE, the HMM island
is used.
\item If a feature has an ENSR ID, and ENSR==TRUE, the ENSR feature
is used.
}

If a feature has both an ENSR ID and an HMMI ID, and both options are TRUE,
then the ENSR start and end coordinates will take precedence over its HMMI.

The above shenanigans produce the GRanges object returned as \code{gr} in a List.
The \code{intercept} value returned with the model is its fixed (B0) coefficient.
The \code{cleanup} function returned with the model transforms its raw output.
}
\examples{

clock <- getClock(model="horvathshrunk", genome="hg38")

}
