% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_analysis_functions.R
\name{outlier_analysis}
\alias{outlier_analysis}
\title{With the grouptablist generated by count_outliers - run through and run a
    fisher exact test to get the p.value for the difference in outlier count
    for each feature in each of your comparisons}
\usage{
outlier_analysis(grouptablist, fraction_table = NULL,
    fraction_samples_cutoff = 0.3,
    write_out_tables = FALSE, outfilepath = tempdir())
}
\arguments{
\item{grouptablist}{table generated by the count_outliers function. NOTE that
the inputted grouptablist will be deciphered to determine its content.
This means that user decides to input the outliertab or aggregate tab,
and the output will analyze according to what positive and negative
information is contained within the table}

\item{fraction_table}{DEFAULT: NULL; Input a fraction table to filter to
only include features that have x% of samples in the ingroup that have
an outlier.}

\item{fraction_samples_cutoff}{DEFAULT: 0.3; Input a fractional cut off for
the of samples that need to have an outlier for feature to be
considered. ex) 10 samples in ingroup - 3 need to have an outlier for
feature to be considered significant}

\item{write_out_tables}{DEFAULT: FALSE; utility in function to write out
each of the analyses to a separate table to whereever <outfilepath> is
specfied.}

\item{outfilepath}{the full string path to where the file should output to,
DEFAULT is a tempdir()}
}
\value{
the analysis table with p.value, fdr, and raw data per comparison
}
\description{
With the grouptablist generated by count_outliers - run through and run a
    fisher exact test to get the p.value for the difference in outlier count
    for each feature in each of your comparisons
}
\examples{

data("sample_phosphodata")
reftable_function_out <- make_outlier_table(sample_phosphodata[1:1000,])
outliertab <- reftable_function_out$outliertab

data("sample_annotationdata")
groupings <- comparison_groupings(sample_annotationdata)

count_outliers_out <- count_outliers(groupings, outliertab,
    aggregate_features = FALSE)
grouptablist <- count_outliers_out$grouptablist
fractiontab <- count_outliers_out$fractiontab

outlier_analysis_out <- outlier_analysis(grouptablist,
    fraction_table = fractiontab)
}
\keyword{blacksheepr}
\keyword{deva}
\keyword{outliers}
