% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBreakpointr.R
\name{runBreakpointr}
\alias{runBreakpointr}
\title{Find breakpoints in Strand-seq data}
\usage{
runBreakpointr(
  bamfile,
  ID = basename(bamfile),
  pairedEndReads = TRUE,
  chromosomes = NULL,
  windowsize = 1e+06,
  binMethod = "size",
  multi.sizes = NULL,
  trim = 10,
  peakTh = 0.33,
  zlim = 3.291,
  background = 0.05,
  min.mapq = 10,
  pair2frgm = FALSE,
  filtAlt = FALSE,
  genoT = "fisher",
  minReads = 20,
  maskRegions = NULL,
  conf = 0.99
)
}
\arguments{
\item{bamfile}{A file with aligned reads in BAM format.}

\item{ID}{A character string that will serve as identifier in downstream functions.}

\item{pairedEndReads}{Set to \code{TRUE} if you have paired-end reads in your file.}

\item{chromosomes}{If only a subset of the chromosomes should be binned, specify them here.}

\item{windowsize}{The window size used to calculate deltaWs, either number of reads or genomic size depending on \code{binMethod}.}

\item{binMethod}{Method used to calculate optimal number of reads in the window ("size", "reads"). By default \code{binMethod='size'}.}

\item{multi.sizes}{User defined multiplications of the original window size.}

\item{trim}{The amount of outliers in deltaWs removed to calculate the stdev (10 will remove top 10\% and bottom 10\% of deltaWs).}

\item{peakTh}{The treshold that the peak deltaWs must pass to be considered a breakpoint (e.g. 0.33 is 1/3 of max(deltaW)).}

\item{zlim}{The number of stdev that the deltaW must pass the peakTh (ensures only significantly higher peaks are considered).}

\item{background}{The percent (e.g. 0.05 = 5\%) of background reads allowed for WW or CC genotype calls.}

\item{min.mapq}{Minimum mapping quality when importing from BAM files.}

\item{pair2frgm}{Set to \code{TRUE} if every paired-end read should be merged into a single fragment.}

\item{filtAlt}{Set to \code{TRUE} if you want to filter out alternative alignments defined in 'XA' tag.}

\item{genoT}{A method ('fisher' or 'binom') to genotype regions defined by a set of breakpoints.}

\item{minReads}{The minimal number of reads between two breaks required for genotyping.}

\item{maskRegions}{List of regions to be excluded from the analysis in \code{\link{GRanges-class}} object.}

\item{conf}{Desired confidence interval of localized breakpoints.}
}
\value{
A \code{\link{BreakPoint}} object.
}
\description{
Find breakpoints in Strand-seq data. See section Details on how breakpoints are located.
}
\details{
Breakpoints are located in the following way:
\enumerate{
\item calculate deltaWs chromosome-by-chromsome
\item localize breaks that pass zlim above the threshold
\item genotype both sides of breaks to confirm whether strand state changes
\item write a file of _reads, _deltaWs and _breaks in a chr fold -> can upload on to UCSC Genome browser
\item write a file for each index with all chromosomes included -> can upload on to UCSC Genome browser
}
}
\examples{
## Get an example file
exampleFolder <- system.file("extdata", "example_bams", package="breakpointRdata")
exampleFile <- list.files(exampleFolder, full.names=TRUE)[1]
## Run breakpointR
brkpts <- runBreakpointr(exampleFile, chromosomes='chr22', pairedEndReads=FALSE)

}
\author{
David Porubsky, Ashley Sanders, Aaron Taudt
}
