% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeBreaks.R
\name{summarizeBreaks}
\alias{summarizeBreaks}
\title{Compile breakpoint summary table}
\usage{
summarizeBreaks(breakpoints)
}
\arguments{
\item{breakpoints}{A list containing breakpoints stored in \code{\link{GRanges-class}} object.}
}
\value{
A \code{data.frame} of compiled breakpoints together with confidence intervals.
}
\description{
This function will calculate deltaWs from a \code{\link{GRanges-class}} object with read fragments.
}
\examples{
## Get some files that you want to load
exampleFolder <- system.file("extdata", "example_results", package="breakpointRdata")
file <- list.files(exampleFolder, full.names=TRUE)[1]
breakpoints <- get(load(file))[c('breaks', 'confint')]
summarizeBreaks(breakpoints)
}
\author{
David Porubsky
}
