% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{QueryBrenda}
\alias{QueryBrenda}
\title{Query for multiple enzymes.}
\usage{
QueryBrenda(brenda, EC, n.core = 0, fields = FALSE, ...)
}
\arguments{
\item{brenda}{A \code{tibble} containing information from BRENDA.}

\item{EC}{A string of the EC number.}

\item{n.core}{Integer specifying the number of cores to use. Default is 0,
which would result in using all available cores.}

\item{fields}{A character vector indicating fields to parse. Default is
FALSE, which would be returning all fields.}

\item{...}{Other parameters passed to \code{\link[=QueryBrendaBase]{QueryBrendaBase()}}.}
}
\value{
A list of \code{brenda.entry} objects.
}
\description{
Use a vector of EC numbers to retrieve information from the
BRENDA \code{tibble} read in by \code{\link[=ReadBrenda]{ReadBrenda()}}. Invalid EC numbers will be removed
and a message will be generated.
}
\examples{
df <- ReadBrenda(system.file("extdata", "brenda_download_test.txt",
                          package = "brendaDb"))
res <- QueryBrenda(brenda = df, EC = c("1.1.1.1", "1.1.1.10", "6.3.5.8"),
                   n.core = 2, organisms = "Homo sapiens")

}
\seealso{
\code{\link[=QueryBrendaBase]{QueryBrendaBase()}} \code{\link[=ConfigBPCores]{ConfigBPCores()}} \code{\link[=SelectOrganism]{SelectOrganism()}}
}
