% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSignatures.R
\name{getSignatures}
\alias{getSignatures}
\title{Obtain microbe signatures from BugSigDB}
\usage{
getSignatures(
  df,
  tax.id.type = c("ncbi", "metaphlan", "taxname"),
  tax.level = "mixed",
  exact.tax.level = TRUE,
  min.size = 1
)
}
\arguments{
\item{df}{\code{data.frame} storing BugSigDB data. Typically obtained via
\code{\link{importBugSigDB}}.}

\item{tax.id.type}{Character. Taxonomic ID type of the returned microbe sets.
Either \code{"ncbi"} (default), \code{"metaphlan"}, or \code{"taxname"}.}

\item{tax.level}{character. Either \code{"mixed"} or any subset of
\code{c("kingdom", "phylum", "class", "order", "family", "genus", "species",
"strain")}. This full vector is equivalent to \code{"mixed"}.}

\item{exact.tax.level}{logical. Should only the exact taxonomic level
specified by \code{tax.level} be returned? Defaults to \code{TRUE}.
If \code{FALSE}, a more general \code{tax.level} is extracted for
microbes given at a more specific taxonomic level.}

\item{min.size}{integer. Minimum signature size. Defaults to 1, which will
filter out empty signature. Use \code{min.size = 0} to keep empty signatures.}
}
\value{
a \code{list} of microbe signatures. Each signature is a character
vector of taxonomic IDs depending on the chosen \code{tax.id.type}.
}
\description{
Functionality for obtaining microbe signatures from BugSigDB
}
\examples{
 df <- importBugSigDB()
 sigs <- getSignatures(df)
}
\references{
BugSigDB: \url{https://bugsigdb.org}
}
\seealso{
importBugSigDB
}
