% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial_models.R
\name{mixBinom}
\alias{mixBinom}
\title{EM algorithm for estimating binomial mixture model}
\usage{
mixBinom(
  k,
  n,
  n_components = 2,
  p_init = NULL,
  learn_p = TRUE,
  min_iter = 10,
  max_iter = 1000,
  logLik_threshold = 1e-05
)
}
\arguments{
\item{k}{A vector of integers. number of success}

\item{n}{A vector of integers. number of trials}

\item{n_components}{A number. number of components}

\item{p_init}{A vector of floats with length n_components, the initial value
of p}

\item{learn_p}{bool(1) or a vector of bool, whether learn each p}

\item{min_iter}{integer(1). number of minimum iterations}

\item{max_iter}{integer(1). number of maximum iterations}

\item{logLik_threshold}{A float. The threshold of logLikelihood increase for
detecting convergence}
}
\value{
a list containing \code{p}, a vector of floats between 0 and 1
giving the estimated success probability for each component, \code{psi},
estimated fraction of each component in the mixture, and \code{prob}, the
matrix of fitted probabilities of each observation belonging to each
component.
}
\description{
EM algorithm for estimating binomial mixture model
}
\examples{
n1 <- array(sample(1:30, 50, replace = TRUE))
n2 <- array(sample(1:30, 200, replace = TRUE))
k1 <- apply(n1, 1, rbinom, n = 1, p = 0.5)
k2 <- apply(n2, 1, rbinom, n = 1, p = 0.01)
RV <- mixBinom(c(k1, k2), c(n1, n2))
}
