% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich-plots.R
\name{cnetmod}
\alias{cnetmod}
\alias{cnetPlotUI}
\alias{cnetPlotServer}
\title{Cnetplot module}
\usage{
cnetPlotUI(id, panel)

cnetPlotServer(id, obj, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{obj}{reactive, dataframe containing enrichment results}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with plot UI
server invisibly returns NULL (used for side effects)
}
\description{
UI & module to generate Cnetplots.
}
\examples{
library(shiny)

# get DESeqResults object
data(res_dex, package='carnation')

obj <- reactive({ res })

config <- reactiveVal(get_config())

# run simple shiny app with plot
if(interactive()){
  shinyApp(
    ui = fluidPage(
           sidebarPanel(cnetPlotUI('p', 'sidebar')),
           mainPanel(cnetPlotUI('p', 'main'))
         ),
    server = function(input, output, session){
               cnetPlotServer('p', obj, config)
             }
  )
}

}
