% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{create_access_yaml}
\alias{create_access_yaml}
\title{Create access yaml}
\usage{
create_access_yaml(user, user_group, data_area)
}
\arguments{
\item{user}{User name}

\item{user_group}{User group}

\item{data_area}{Path to data area containing RDS files}
}
\value{
Invisibly returns \code{NULL}. This function is primarily used for
its side effect of saving a yaml file with access settings
}
\description{
This function creates an access yaml file.
This is primarily intended for the first run.
}
\examples{
# save access details to file
home <- Sys.getenv('HOME')

# create carnation data area if it doesn't exist
carnation_home <- file.path(home, 'carnation/data')
if(!dir.exists(carnation_home)) dir.create(carnation_home)

create_access_yaml(user = 'admin',
                   user_group = 'admin',
                   data_area = carnation_home)

}
