% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich-plots.R
\name{distillmod}
\alias{distillmod}
\alias{distillPlotUI}
\alias{distillPlotServer}
\title{Distilled enrichment map module}
\usage{
distillPlotUI(id, panel)

distillPlotServer(id, obj, args, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{obj}{reactive containing 'distilled' enrichment results}

\item{args}{reactive, list with plot arguments, 'numcat' (number of categories to plot)}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with plot UI
server returns reactive with number of plotted terms
}
\description{
UI & module to generate distill enrichment map plots.
}
\examples{
library(GeneTonic)
library(shiny)

# get DESeqResults object
data(res_dex, package='carnation')

# get enrichResult object
data(eres_dex, package='carnation')

# preprocess & convert to GeneTonic object
eres2 <- GeneTonic::shake_enrichResult(eres_dex)
gt <- enrich_to_genetonic(eres_dex, res_dex)

# get distilled results
df <- distill_enrichment(
        eres2,
        res_dex,
        gt$anno_df,
        n_gs = 10,
        cluster_fun = "cluster_markov"
      )

# number of plotted terms
args <- reactive({ list(numcat=10) })

config <- reactiveVal(get_config())

# run simple shiny app with plot
if(interactive()){
  shinyApp(
    ui = fluidPage(
           sidebarPanel(distillPlotUI('p', 'sidebar')),
           mainPanel(distillPlotUI('p', 'main'))
         ),
    server = function(input, output, session){
               numcat <- observe({
                 distillPlotServer('p',
                                   reactive({ df }),
                                   args,
                                   config)
               })
             }
  )
}

}
