% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buttons.R
\name{dlmod}
\alias{dlmod}
\alias{downloadButtonUI}
\alias{downloadButtonServer}
\title{Download button module}
\usage{
downloadButtonUI(id)

downloadButtonServer(id, outplot, plot_type)
}
\arguments{
\item{id}{Module id}

\item{outplot}{reactive plot handle}

\item{plot_type}{reactive/static value used for output filename}
}
\value{
UI returns tagList with download button UI.
Server invisibly returns NULL (used for side effects).
}
\description{
Module UI & server for download buttons.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(ggplot2)

# get example object
obj <- make_example_carnation_object()
res <- as.data.frame(obj$res[[1]])

# make MA plot
p <- ggplot(res, aes(x=baseMean, y=log2foldChange)) +
       geom_point(color='black', alpha=0.5)

outplot <- reactive({ p })

# app with a single button to download a plot
if(interactive()){
  shinyApp(
    ui = fluidPage(
           downloadButtonUI('p')
         ),
    server = function(input, output, session){
               downloadButtonServer('p', outplot, 'maplot')
             }
  )
}
\dontshow{\}) # examplesIf}
}
