% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich-plots.R
\name{emapmod}
\alias{emapmod}
\alias{enrichmapUI}
\alias{enrichmapServer}
\title{Enrichment map plot module}
\usage{
enrichmapUI(id, panel)

enrichmapServer(id, obj, res_obj, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{obj}{reactiveValues object containing GeneTonic object}

\item{res_obj}{reactive, dataframe containing enrichment results}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with plot UI
server invisibly returns NULL (used for side effects)
}
\description{
UI & module to generate enrichment map plots.
}
\examples{
library(shiny)

# get DESeqResults object
data(res_dex, package='carnation')

# get enrichResult object
data(eres_dex, package='carnation')

# convert to GeneTonic object
gt <- GeneTonic::shake_enrichResult(eres_dex)

obj <- reactive({
  list(l_gs = gt$l_gs,
       anno_df = gt$anno_df,
       label = 'comp1')
})

res_obj <- reactive({ res })

config <- reactiveVal(get_config())

# run simple shiny app with plot
if(interactive()){
  shinyApp(
    ui = fluidPage(
           sidebarPanel(enrichmapUI('p', 'sidebar')),
           mainPanel(enrichmapUI('p', 'main'))
         ),
    server = function(input, output, session){
               enrichmapServer('p', obj, res_obj, config)
             }
  )
}

}
