% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional-enrichment.R
\name{funenrichmod}
\alias{funenrichmod}
\alias{enrichUI}
\alias{enrichServer}
\title{Functional enrichment module}
\usage{
enrichUI(id, panel, tab = "none")

enrichServer(id, obj, upset_table, gene_scratchpad, reset_genes, config)
}
\arguments{
\item{id}{ID string used to match the ID used to call the module UI function}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{tab}{string, if 'table' show table settings, if 'plots' show plot settings;
if 'compare_results', show comparison settings.}

\item{obj}{reactiveValues object containing carnation object}

\item{upset_table}{reactive, data from upset plot module}

\item{gene_scratchpad}{reactive, genes selected in gene scratchpad}

\item{reset_genes}{reactive to reset genes in scratchpad}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with plot UI
server returns reactive with gene selected from functional enrichment tables.
}
\description{
UI & module to show functional enrichment tables & plots.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(DESeq2)

# Create reactive values to simulate app state
oobj <- make_example_carnation_object()

obj <- reactiveValues(
   dds = oobj$dds,
   rld = oobj$rld,
   res = oobj$res,
   all_dds = oobj$all_dds,
   all_rld = oobj$all_rld,
   dds_mapping = oobj$dds_mapping
)

upset_table <- reactiveValues(tbl=NULL, intersections=NULL, set_labels=NULL)

gene_scratchpad <- reactive({ c('gene1', 'gene2') })

config <- reactiveVal(get_config())

shinyApp(
  ui = fluidPage(
         sidebarPanel(
           conditionalPanel(condition = "input.func == 'Table'",
             enrichUI('p', 'sidebar', 'table')
           ),
           conditionalPanel(condition = "input.func == 'Plot'",
             enrichUI('p', 'sidebar', 'plot')
           ),
           conditionalPanel(condition = "input.func == 'Compare results'",
             enrichUI('p', 'sidebar', 'compare_results')
           )
         ),
         mainPanel(
             tabsetPanel(id='func',
               tabPanel('Table',
                 enrichUI('p', 'main', 'table')
               ), # tabPanel table

               tabPanel('Plot',
                 enrichUI('p', 'main', 'plot')
               ), # tabPanel plot

               tabPanel('Compare results',
                 enrichUI('p', 'main', 'compare_results')
               ) # tabPanel compare_results

             ) # tabsetPanel func
           ) # tabPanel
         ),
  server = function(input, output, session){
             enrich_data <- enrichServer('p', obj,
                                         upset_table,
                                         gene_scratchpad,
                                         reactive({ FALSE }),
                                         config)
           }
)
\dontshow{\}) # examplesIf}
}
