% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich-plots.R
\name{fuzzymod}
\alias{fuzzymod}
\alias{fuzzyPlotUI}
\alias{fuzzyPlotServer}
\title{Fuzzy enrichment map module}
\usage{
fuzzyPlotUI(id, panel)

fuzzyPlotServer(id, obj, args, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{obj}{reactive containing 'distilled' enrichment results}

\item{args}{reactive, list with plot arguments, 'numcat' (number of categories to plot)}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with plot UI
server returns reactive with number of plotted terms
}
\description{
UI & module to generate fuzzy enrichment map plots.
}
\examples{
library(shiny)

# get enrichResult object
data(eres_dex, package='carnation')

# preprocess & convert to GeneTonic object
gt <- GeneTonic::shake_enrichResult(eres_dex)

# get distilled results
df <- GeneTonic::gs_fuzzyclustering(gt[seq_len(10),],
        similarity_threshold = 0.35,
        fuzzy_seeding_initial_neighbors = 3,
        fuzzy_multilinkage_rule = 0.5)

# number of plotted terms
args <- reactive({ list(numcat=10) })

config <- reactiveVal(get_config())

# run simple shiny app with plot
if(interactive()){
  shinyApp(
    ui = fluidPage(
           sidebarPanel(fuzzyPlotUI('p', 'sidebar')),
           mainPanel(fuzzyPlotUI('p', 'main'))
         ),
    server = function(input, output, session){
               numcat <- observe({
                 fuzzyPlotServer('p',
                                 reactive({ df }),
                                 args,
                                 config)
               })
             }
  )
}

}
