% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_gene_counts}
\alias{get_gene_counts}
\title{Get read counts for gene}
\usage{
get_gene_counts(dds, gene, intgroup = "condition", norm_method = "libsize")
}
\arguments{
\item{dds}{DESeqDataSet object}

\item{gene}{gene name vector}

\item{intgroup}{metadata variable to attach to counts}

\item{norm_method}{normalization method, can be 'libsize' (default) or 'vst'}
}
\value{
data.frame with gene counts
}
\description{
This is a simple function to obtain read counts for a
specified gene, based on the DESeq2::plotCounts function.
}
\examples{
# make example DESeq data set
dds <- DESeq2::makeExampleDESeqDataSet()

# get counts for gene1
gg <- get_gene_counts(dds, 'gene1')

}
