% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{heatmapmod}
\alias{heatmapmod}
\alias{heatmapUI}
\alias{heatmapServer}
\title{Heatmap module}
\usage{
heatmapUI(id, panel)

heatmapServer(id, obj, coldata, plot_args, gene_scratchpad, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{obj}{reactiveValues object containing carnation object}

\item{coldata}{reactiveValues object containing object metadata}

\item{plot_args}{reactive containing 'fdr.thres' (padj threshold), 'fc.thres' (log2FC) &
'upset_data' (list containing data from upset plot module)}

\item{gene_scratchpad}{reactiveValues object containing genes selected in scratchpad which will
be labeled}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with heatmap UI.
Server invisibly returns NULL (used for side effects).
}
\description{
Module UI & server to generate heatmap.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(DESeq2)

# Create reactive values to simulate app state
oobj <- make_example_carnation_object()

obj <- reactiveValues(
   dds = oobj$dds,
   rld = oobj$rld,
   res = oobj$res,
   all_dds = oobj$all_dds,
   all_rld = oobj$all_rld,
   dds_mapping = oobj$dds_mapping
)

cdata <- lapply(oobj$rld, function(x) colData(x))

coldata <- reactiveValues( all=cdata, curr=cdata )

plot_args <- reactive({
  list(
    fdr.thres=0.1,
    fc.thres=0,
    upset_data=list(genes=NULL, labels=NULL)
  )
})

gene_scratchpad <- reactive({ c('gene1', 'gene2') })

config <- reactiveVal(get_config())

shinyApp(
  ui = fluidPage(
         sidebarPanel(heatmapUI('p', 'sidebar')),
         mainPanel(heatmapUI('p', 'sidebar'))
       ),
  server = function(input, output, session){
             heatmapServer('p', obj, coldata,
                           plot_args, gene_scratchpad, config)
           }
)
\dontshow{\}) # examplesIf}
}
