% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buttons.R
\name{helpmod}
\alias{helpmod}
\alias{helpButtonUI}
\alias{helpButtonServer}
\title{Help button module}
\usage{
helpButtonUI(id)

helpButtonServer(id, ...)
}
\arguments{
\item{id}{Module id. This also doubles as prefixes for help text files.}

\item{...}{other params passed to helpModal()}
}
\value{
UI returns tagList with help button UI.
Server invisibly returns NULL (used for side effects).
}
\description{
Module UI & server for help buttons.
}
\examples{
library(shiny)

# app with a single help button to show DE summary table details
if(interactive()){
  shinyApp(
    ui = fluidPage(
           helpButtonUI('de_summary_help')
         ),
    server = function(input, output, session){
               helpButtonServer('de_summary_help')
             }
  )
}

}
