% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich-plots.R
\name{horizonmod}
\alias{horizonmod}
\alias{horizonUI}
\alias{horizonServer}
\title{Horizon plot module}
\usage{
horizonUI(id, panel)

horizonServer(id, obj, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{obj}{reactiveValues object containing two GeneTonic objects}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with plot UI
server invisibly returns NULL (used for side effects)
}
\description{
UI & module to generate horizon plots.
}
\examples{
library(shiny)

# get enrichResult object
data(eres_dex, package='carnation')

# convert to GeneTonic object
gt <- GeneTonic::shake_enrichResult(eres_dex)

# get second enrichResult object
data(eres_cell, package='carnation')

# convert to GeneTonic object
gt1 <- GeneTonic::shake_enrichResult(eres_cell)

obj <- reactive({
  list(
    obj1 = list(l_gs = gt$l_gs,
             anno_df = gt$anno_df,
             label = 'comp1'),
    obj2 = list(l_gs = gt1$l_gs,
             anno_df = gt1$anno_df,
             label = 'comp2')
  )
})

config <- reactiveVal(get_config())

# run simple shiny app with plot
if(interactive()){
  shinyApp(
    ui = fluidPage(
           sidebarPanel(horizonUI('p', 'sidebar')),
           mainPanel(horizonUI('p', 'main'))
         ),
    server = function(input, output, session){
               horizonServer('p', obj, config)
             }
  )
}

}
