% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-new-data.R
\name{loadmod}
\alias{loadmod}
\alias{loadDataUI}
\alias{loadDataServer}
\title{Load data module}
\usage{
loadDataUI(id)

loadDataServer(id, username, config, rds = NULL)
}
\arguments{
\item{id}{Module id}

\item{username}{user name}

\item{config}{reactive list with config settings}

\item{rds}{Object to be edited}
}
\value{
UI returns tagList with module UI
Server returns reactive with app reload trigger
}
\description{
Module UI & server to load new data
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)

username <- 'admin'

config <- reactiveVal(get_config())

obj <- make_example_carnation_object()

rds <- reactive({ obj=obj })

shinyApp(
  ui = fluidPage(
         loadDataUI('p')
       ),
  server = function(input, output, session){
             loadDataServer('p', username=username, config, rds)
           }
)

\dontshow{\}) # examplesIf}
}
