% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{my.summary}
\alias{my.summary}
\title{Summarize DESeq2 results into a dataframe}
\usage{
my.summary(res, dds, alpha, lfc.thresh = 0)
}
\arguments{
\item{res}{DESeq2 results object}

\item{dds}{DEseq2 object}

\item{alpha}{Alpha level at which to call significantly changing genes}

\item{lfc.thresh}{log2FoldChange threshold}
}
\value{
Dataframe of summarized results
}
\description{
summary(res) prints out info; this function captures it into a dataframe
}
\examples{
n_genes <- 100

#  make mock dds list
dds <- DESeq2::makeExampleDESeqDataSet(n=n_genes)

# make mock results df
res <- data.frame(
         baseMean = runif(n_genes, 10, 1000),
         log2FoldChange = rnorm(n_genes, 0, 2),
         lfcSE = runif(n_genes, 0.1, 0.5),
         stat = rnorm(n_genes, 0, 3),
         pvalue = runif(n_genes, 0, 1),
         padj = runif(n_genes, 0, 1),
         symbol = paste0("GENE", 1:n_genes),
         row.names = paste0("gene", 1:n_genes)
       )

# get summary
df <- my.summary(res, dds, alpha=0.1)

}
