% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotPCA.san}
\alias{plotPCA.san}
\title{Adjustable PCA plot}
\usage{
plotPCA.san(
  object,
  intgroup = "group",
  pcx,
  pcy,
  pcz = NULL,
  ntop = 500,
  samples = NULL,
  loadings = FALSE,
  loadings_ngenes = 10
)
}
\arguments{
\item{object}{normalized DESeqDataSet object}

\item{intgroup}{metadata variable to use for grouping samples}

\item{pcx}{principal component to plot on x-axis}

\item{pcy}{principal component to plot on y-axis}

\item{pcz}{principal component to plot on z-axis. If not NULL,
function returns a 3-D PCA plot.}

\item{ntop}{number of most-variable genes to use}

\item{samples}{vector of sample names to show on plot}

\item{loadings}{boolean, show gene loadings? Default is FALSE.}

\item{loadings_ngenes}{integer, # genes to show loadings for (default=10)}
}
\value{
ggplot handle
}
\description{
Create a PCA plot with specified PCs on x- and y-axis
}
\examples{
# make example dds object
dds <- DESeq2::makeExampleDESeqDataSet()

# normalize
rld <- DESeq2::varianceStabilizingTransformation(dds, blind=TRUE)

# make pca plot
p <- plotPCA.san(rld, intgroup='condition', pcx='PC1', pcy='PC2')


}
