% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{read_access_yaml}
\alias{read_access_yaml}
\title{Read access yaml with user groups and data areas}
\usage{
read_access_yaml()
}
\value{
return carnation access settings from yaml file
}
\description{
This function reads the access yaml file and
returns user groups and data areas
as a list of data frames.
}
\examples{
# save access details to file
home <- Sys.getenv('HOME')

# create carnation data area if it doesn't exist
carnation_home <- file.path(home, 'carnation/data')
if(!dir.exists(carnation_home)) dir.create(carnation_home)

create_access_yaml(user = 'admin',
                   user_group = 'admin',
                   data_area = carnation_home)

al <- read_access_yaml()

}
