% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter-plot.R
\name{scattermod}
\alias{scattermod}
\alias{scatterPlotUI}
\alias{scatterPlotServer}
\title{Scatterplot module}
\usage{
scatterPlotUI(id, panel)

scatterPlotServer(id, obj, plot_args, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main' passed to UI}

\item{obj}{reactiveValues object containing carnation object passed to server}

\item{plot_args}{reactive containing 'fdr.thres' (padj threshold), 'fc.thres' (log2FC) &
'gene.to.plot' (genes to be labeled) passed to server}

\item{config}{reactive list with config settings passed to server}
}
\value{
UI returns tagList with scatter plot UI.
Server invisibly returns NULL (used for side effects).
}
\description{
Module UI + server for generating scatter plots.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)

# Create reactive values to simulate app state
oobj <- make_example_carnation_object()

obj <- reactiveValues(
   dds = oobj$dds,
   rld = oobj$rld,
   res = oobj$res,
   all_dds = oobj$all_dds,
   all_rld = oobj$all_rld,
   dds_mapping = oobj$dds_mapping
)

plot_args <- reactive({
  list(
    fdr.thres=0.1,
    fc.thres=0,
    gene.to.plot=c('gene1', 'gene2')
  )
})

config <- reactiveVal(get_config())

shinyApp(
  ui = fluidPage(
         sidebarPanel(scatterPlotUI('p', 'sidebar')),
         mainPanel(scatterPlotUI('p', 'sidebar'))
       ),
  server = function(input, output, session){
             scatterPlotServer('p', obj, plot_args, config)
           }
)
\dontshow{\}) # examplesIf}
}
