% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{top.genes}
\alias{top.genes}
\title{Get top DE genes by log2FoldChange or adjusted p-value}
\usage{
top.genes(res, fdr.thres = 0.01, fc.thres = 0, n = 10, by = "log2FoldChange")
}
\arguments{
\item{res}{data.frame with DE analysis results}

\item{fdr.thres}{FDR threshold}

\item{fc.thres}{log2FoldChange threshold}

\item{n}{number of genes to return}

\item{by}{metric to determine top genes ('log2FoldChange' or 'padj')}
}
\value{
vector of gene symbols
}
\description{
Get top DE genes by log2FoldChange or adjusted p-value
}
\examples{
# get DE results
data(res_dex, package='carnation')

g <- top.genes(res_dex)
}
