% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upset-plot.R
\name{upsetmod}
\alias{upsetmod}
\alias{upsetPlotUI}
\alias{upsetPlotServer}
\title{Upset plot module}
\usage{
upsetPlotUI(id, panel)

upsetPlotServer(id, obj, plot_args, gene_scratchpad, reset_genes, config)
}
\arguments{
\item{id}{Module id}

\item{panel}{string, can be 'sidebar' or 'main'}

\item{obj}{reactiveValues object containing carnation object}

\item{plot_args}{reactive containing 'fdr.thres' (padj threshold) & 'fc.thres' (log2FC)}

\item{gene_scratchpad}{reactiveValues object containing genes selected in scratchpad}

\item{reset_genes}{reactive to reset gene scratchpad selection}

\item{config}{reactive list with config settings}
}
\value{
UI returns tagList with upset plot UI.
Server returns reactive with list containing upset table, intersections
& selected genes.
}
\description{
Module UI & server to generate upset plots.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)

oobj <- make_example_carnation_object()

obj <- reactiveValues(
   dds = oobj$dds,
   rld = oobj$rld,
   res = oobj$res,
   all_dds = oobj$all_dds,
   all_rld = oobj$all_rld,
   dds_mapping = oobj$dds_mapping
)

plot_args <- reactive({
  list(
    fdr.thres=0.1,
    fc.thres=0
  )
})

gene_scratchpad <- reactive({ c('gene1', 'gene2') })

reset_genes <- reactiveVal()

config <- reactiveVal(get_config())

shinyApp(
  ui = fluidPage(
         sidebarPanel(upsetPlotUI('p', 'sidebar')),
         mainPanel(upsetPlotUI('p', 'sidebar'))
       ),
  server = function(input, output, session){
             upset_data <- upsetPlotServer('p', obj, plot_args,
                                           gene_scratchpad,
                                           reset_genes, config)
           }
)
\dontshow{\}) # examplesIf}
}
