% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbaf-automatedStatistics.R
\name{automatedStatistics}
\alias{automatedStatistics}
\title{Perform the requested statistics for various studies / subgroups of a
study.}
\usage{
automatedStatistics(submissionName, obtainedDataType =
  "multiple studies", calculate = c("frequencyPercentage", "frequencyRatio",
  "meanValue"), topGenes = TRUE, cutoff=NULL, round=TRUE)
}
\arguments{
\item{submissionName}{a character string containing name of interest. It is
used for naming the process.}

\item{obtainedDataType}{a character string that specifies the type of input
data produced by the previous function. Two options are availabe:
\code{"single study"} for obtainOneStudy() and \code{"multiple studies"} for
obtainMultipleStudies(). The function uses obtainedDataType and
submissionName to construct the name of the BiocFileCach object and then
finds the appropriate data inside it. Default value is multiple studies`.}

\item{calculate}{a character vector that containes the statistical procedures
users prefer the function to compute. The complete results can be obtained
by \code{c("frequencyPercentage", "frequencyRatio", "meanValue",
"medianValue")}. This will tell the function to compute the following:
\code{"frequencyPercentage"}, which is the percentge of samples having the
value greather than specific cutoff divided by the total sample size for
every study / study subgroup;
\code{"frequency ratio"}, which shows the number of selected samples divided
by the total number of samples that give the frequency percentage for every
study / study subgroup. It shows the selected and total sample sizes.;
\code{"Mean Value"}, that contains mean value of selected samples for each
study;
\code{"Median Value"}, which shows the median value of selected samples for
each study.
The default input is \code{calculate = c("frequencyPercentage",
"frequencyRatio", "meanValue")}.}

\item{topGenes}{a logical value that, if set as TRUE, causes the function to
create three data.frame that contain the five top genes for each cancer. To
get all the three data.frames, "frequencyPercentage", "meanValue" and
"MedianValue" must have been included for \code{calculate}.}

\item{cutoff}{a number used to limit samples to those that are greather than
this number (cutoff). The default value for methylation data is \code{0.8}
while gene expression studies use default value of \code{2}. For methylation
studies, it is \code{average of relevant locations}, for the rest, it is
\code{"log z-score"}. To change the cutoff to any desired number, change the
option to \code{cutoff = desiredNumber} in which desiredNumber is the number
of interest.}

\item{round}{a logical value that, if set to be \code{TRUE}, will force the
function to round all the calculated values to two decimal places. The
default value is \code{TRUE}.}
}
\value{
A new section in the BiocFileCache object that was created by one of
the obtainOneStudy() or obtainMultipleStudies() functions. It contains a list
 that contains some or all of the following statistical measurements for
 every gene group, based on what user has chosen: \code{Frequency.Percentage}
 , \code{Top.Genes.of.Frequency.Percentage}, \code{Frequency.Ratio},
 \code{Mean.Value}, \code{Top.Genes.of.Mean.Value}, \code{Median},
 \code{Top.Genes.of.Median}.
}
\description{
This function calculates frequency percentage, frequency ratio,
mean value and median value of samples greater than specific cutoff in the
selected study / subgroups of the study. Furthermore, it can looks for the
five genes that contain the highest values in each study / study subgroup.
It uses the data generated by obtainOneStudy()/obtainMultipleStudies()
function.
}
\details{
\tabular{lllll}{
Package: \tab cbaf \cr
Type: \tab Package \cr
Version: \tab 1.31.1 \cr
Date: \tab 2025-10-26 \cr
License: \tab Artistic-2.0 \cr
}
}
\examples{
genes <- list(K.demethylases = c("KDM1A", "KDM1B", "KDM2A", "KDM2B", "KDM3A",
 "KDM3B", "JMJD1C", "KDM4A"), K.methyltransferases = c("SUV39H1", "SUV39H2",
 "EHMT1", "EHMT2", "SETDB1", "SETDB2", "KMT2A", "KMT2A"))

obtainOneStudy(genes, "test", "Breast Invasive Carcinoma (TCGA, Cell 2015)",
"RNA-Seq", desiredCaseList = c(3,4))

automatedStatistics("test", obtainedDataType = "single study", calculate =
c("frequencyPercentage", "frequencyRatio"))

}
\author{
Arman Shahrisa, \email{shahrisa.arman@hotmail.com} [maintainer,
copyright holder]

Maryam Tahmasebi Birgani, \email{tahmasebi-ma@ajums.ac.ir}
}
