% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{simulate_whx}
\alias{simulate_whx}
\title{Simulate factor matrices and data using priors}
\usage{
simulate_whx(nrow, ncol, rank, aw = 0.1, bw = 1, ah = 0.1, bh = 1)
}
\arguments{
\item{nrow}{Number of features (genes).}

\item{ncol}{Number of cells (samples).}

\item{rank}{Rank (ncol of W, nrow of H).}

\item{aw}{Shape parameter of basis prior.}

\item{bw}{Mean of basis prior. Scale parameter is equal to \code{aw/bw}.}

\item{ah}{Shape parameter of coefficient prior.}

\item{bh}{Mean of coefficient prior. Scale parameter is equal to 
\code{ah/bh}.}
}
\value{
List with elements \code{w}, \code{h}, and \code{x}, each 
   containing basis, coefficient, and count matrices.
}
\description{
Under Bayesian formulation, use prior distributions of factor matrices
and generate simulated data
}
\details{
Basis \code{W} and coefficient matrices \code{H} are sampled from 
gamma distributions (priors) with shape (\code{aw,ah}) and mean
(\code{bw,bh}) parameters. Count data \code{X} are sampled from Poisson
distribution with mean values given by \code{WH}.
}
\examples{
set.seed(1)
x <- simulate_whx(nrow=50,ncol=100,rank=5)
s <- scNMFSet(count=x$x)
s <- vb_factorize(s,ranks=seq(2,8),nrun=5)
plot(s)  
}
