% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{write_10x}
\alias{write_10x}
\title{Write 10x data files}
\usage{
write_10x(object, dir, count = "matrix.mtx", genes = "genes.tsv",
  barcodes = "barcodes.tsv", quote = FALSE)
}
\arguments{
\item{object}{Object of class \code{scNMFSet} containing count data}

\item{dir}{Directory where files are to be written.}

\item{count}{File name for count matrix.}

\item{genes}{File name for gene annotation.}

\item{barcodes}{File name for cell annotation.}

\item{quote}{Suppress quotation marks in output files.}
}
\value{
\code{NULL}
}
\description{
Use an object and write count and annotation files in 10x format.
}
\examples{
set.seed(1)
x <- matrix(rpois(n=12,lambda=3),4,3)
rownames(x) <- seq_len(4)
colnames(x) <- seq_len(3)
s <- scNMFSet(count=x,rowData=seq_len(4),colData=seq_len(3))
write_10x(s,dir='.')
}
