% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_low_qual_cells.R
\name{extract_features}
\alias{extract_features}
\title{Extracts biological and technical features for given dataset}
\usage{
extract_features(counts_nm, read_metrics, prefix = "", output_dir = "",
  common_features = NULL, GO_terms = NULL, extra_genes = NULL,
  organism = "mouse")
}
\arguments{
\item{counts_nm}{Gene expression counts dataframe (genes x cells). Either 
normalised by library size or TPM values}

\item{read_metrics}{Dataframe with mapping statistics produced by python 
pipeline}

\item{prefix}{Prefix of outputfiles}

\item{output_dir}{Output directory of files}

\item{common_features}{Subset of features that are applicable within one 
species, but across cell types}

\item{GO_terms}{DataFrame with gene ontology term IDs, that will be used in 
feature extraction}

\item{extra_genes}{Additional genes used for feature extraction}

\item{organism}{The target organism to generate the features for}
}
\value{
a list with two elements, one providing all features, and one 
providing common features.
}
\description{
Extracts biological and technical features for given dataset
}
\details{
This function takes a combination of gene counts and mapping 
statistics to extract biological and technical features, which than can be 
used for quality data analysis
}
\examples{
data(sample_counts)
data(sample_stats)
sample_counts_nm <- normalise_by_factor(sample_counts, colSums(sample_counts))
sample_features <- extract_features(sample_counts_nm, sample_stats)
}

