% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{FinRes}
\alias{FinRes}
\title{Final Results}
\usage{
FinRes(object, ParCor = TRUE, export = FALSE, ExpName = NULL)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of data
frames resulted from the PreProcessing.}

\item{ParCor}{A logical vector that allows generating a
correlation table. Default is TRUE.}

\item{export}{if `TRUE` (default), exports function output
to CSV file}

\item{ExpName}{string, name of the experiment. Can be NULL}
}
\value{
A data frame that contains all the results.
}
\description{
The FinRes function automatically generates a
data frame that contains all the results.
}
\examples{
data(WSADataset)
wasDF <- WSADataset[seq(1,300,by=1), ]
wsaTD <- CellMig(wasDF)
wsaTD <- wsaPreProcessing(wsaTD,FrameN=55)
wsaTD <-FMI(wsaTD,TimeInterval=10)
wsaTD <-ForwardMigration(wsaTD,TimeInterval=10,)
wsaTD <-FinRes(wsaTD,ParCor=FALSE, export=FALSE)

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
