% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{LinearConv2}
\alias{LinearConv2}
\title{Linear Convolution of a Numeric Matrix}
\usage{
LinearConv2(x, krnl, col.wise = TRUE)
}
\arguments{
\item{x}{numeric matrix that will be used as input for the
convolution;
this matrix typically corresponds to an image where signal
(high values) indicates the presence of a cell or a cell-like
particle}

\item{krnl}{numeric vector corresponding to the kernel
that will be used for the convolution. Briefly, the kernel
includes the weights that will be used to compute a weighted sum
at each position of the input numeric matrix}

\item{col.wise}{logical; shall the linear convolution be performed
in a column-wise or row-wise fashion?}
}
\value{
Linearly convoluted numeric matrix. The resulting matrix
has the same dimensions of the inut matrix
}
\description{
Performs a linear convolution of a Numeric Matrix, using a
user-supplied
linear kernel. The convolution can be executed in a column-wise
fashion
by setting the col.wise argument to TRUE. Alternatively,
the convolution is performed in a row-wise fashion.
}
\examples{
graphics::par(mfrow = c(1, 2))
tmp <- vapply(
    seq_len(12),
    function(i) {(6 + abs(i - 6)) * c(seq(1,10,by=1), seq(10,1,by=-1))},
    FUN.VALUE = numeric(20)
)
cnv.tmp <- cellmigRation:::LinearConv2(tmp, c(-3, 0, 3))
graphics::image(tmp); graphics::image(cnv.tmp)
}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
