% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{getMSDtable}
\alias{getMSDtable}
\title{Getting the Mean Square Displacement}
\usage{
getMSDtable(object)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of data
frames resulted from the PreProcessing.}
}
\value{
A data frame of MSD values.
}
\description{
The MSD function automatically computes the
mean square displacements across several sequential time intervals.
MSD parameters are used to assess the area explored by cells over
time.
}
\examples{
data(TrajectoryDataset)
rmDF <- TrajectoryDataset[seq(1,600,by=1), ]
rmTD <- CellMig(rmDF)
rmTD <- rmPreProcessing(rmTD,FrameN=100)
rmTD <- MSD(rmTD, sLAG=0.25, ffLAG=0.25, export=FALSE)
head(getMSDtable(rmTD))

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
