% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMode.R
\name{plotMode}
\alias{plotMode}
\title{Plot mode fragment size}
\usage{
plotMode(x, order, type, mincount, hline, ...)
}
\arguments{
\item{x}{A long-format dataframe contains the interpeak distance,
a template please refer to the result of "callPeakdist" function.}

\item{order}{The groups show in the final plot,
the input value should be vector, e.g. `groups = c("group1","group2")`,
default is all folders in the folder path.}

\item{type}{The plot type, could choose "bin" or "stacked" chart.
Default is bin plot.}

\item{mincount}{Minimum count of mode fragment size that will be included.
Count number smaller than this value will be removed first,
then proportion of each count value will be calculated.
Default value is 0.}

\item{hline}{The horizontal lines added to the bin plot.
Default lines will be `c(81,112,170)`.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function returns the plot.
}
\description{
Plot mode fragment size
}
\examples{
# Get the path to example data.
path <- examplePath("groups_picard")
# Calculate the modes.
df <- callMode(path = path)
# Plot modes.
plot <- plotMode(df, hline = c(80, 111, 170))
}
\author{
Haichao Wang
}
