% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotModeSummary.R
\name{plotModeSummary}
\alias{plotModeSummary}
\title{Summarize and plot mode fragment size in a stacked bar chart}
\usage{
plotModeSummary(x, order, summarized, mode_partition, ...)
}
\arguments{
\item{x}{A long-format dataframe contains mode fragment size,
a template please refer to the result of `callMode` function.}

\item{order}{The groups show in the final plot,
 the input value should be vector,
 e.g. `groups = c('group1','group2')`,
default is all folders in the folder path.}

\item{summarized}{Logical value, default is False.}

\item{mode_partition}{This should be a list.
This decides how the modes are
partitioned in each stacked bar. Default value is
`list(c(80, 81), c(111, 112), c(167))`.
Also this function will automatically calculate an 'Others' group
which includes
the modes not mentioned by users.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function returns the plot.
}
\description{
Summarize and plot mode fragment size in a stacked bar chart
}
\examples{
# Get the path to example data.
path <- examplePath("groups_picard")
# Calculate the modes.
df <- callMode(path = path)
# Plot mode summary.
plot <- plotModeSummary(df,
    mode_partition = list(c(80, 81), c(111, 112), c(167))
)
}
\author{
Haichao Wang
}
