% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fragment_profile.R
\name{test_isize_KolmogorovSmirnov}
\alias{test_isize_KolmogorovSmirnov}
\title{KolmogorovSmirnov test for insert size}
\usage{
test_isize_KolmogorovSmirnov(control_insert_size, sample_insert_size)
}
\arguments{
\item{control_insert_size}{Vector of insert size of a control sample}

\item{sample_insert_size}{Vector of insert size of a testing sample}
}
\value{
KS.Test result
}
\description{
KolmogorovSmirnov test for insert size
}
\examples{
### Loading example SampleBam file
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)
control_rds<-"BH01_CHR15.SampleBam.rds"
control_RDS_file <- system.file("extdata", control_rds, package = "cfdnakit")
control_fragment_profile <- readRDS(control_RDS_file)
sample.isize <- extract_insert_size(sample_bambin)
healthy.isize <- extract_insert_size(control_fragment_profile)
test_isize_KolmogorovSmirnov(sample.isize,healthy.isize)
}
