% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_peaks.R
\name{assign_peak_segments}
\alias{assign_peak_segments}
\title{Assign whole peaks to all overlapping defined gene loci.}
\usage{
assign_peak_segments(peaks, locusdef)
}
\arguments{
\item{peaks}{A \code{GRanges} object representing regions to be used for enrichment.}

\item{locusdef}{A locus definition object from \code{chipenrich.data}.}
}
\value{
A \code{data.frame} with columns for \code{peak_id, chr, peak_start, peak_end, gene_locus_start, gene_locus_end, gene_id, overlap_start, overlap_end, peak_overlap}. The result is used in \code{num_peaks_per_gene()}.
}
\description{
Determine all overlaps between the set of input regions \code{peaks} and the given locus definition \code{locusdef}. In addition, report where each overlap begins and ends, as well as the length of the overlap.
}
\details{
Typically, this function will not be used alone, but inside \code{chipenrich()} with \code{method = 'broadenrich'}.
}
\examples{

data('locusdef.hg19.nearest_tss', package = 'chipenrich.data')
data('tss.hg19', package = 'chipenrich.data')

file = system.file('extdata', 'test_assign.bed', package = 'chipenrich')
peaks = read_bed(file)

assigned_peaks = assign_peak_segments(
	peaks = peaks,
	locusdef = locusdef.hg19.nearest_tss)

}
