% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dist_to_tss.R
\name{plot_dist_to_tss}
\alias{plot_dist_to_tss}
\title{Plot histogram of distance from peak to nearest TSS}
\usage{
plot_dist_to_tss(peaks, genome = supported_genomes())
}
\arguments{
\item{peaks}{Either a file path or a \code{data.frame} of peaks in BED-like
format. If a file path, the following formats are fully supported via their
file extensions: .bed, .broadPeak, .narrowPeak, .gff3, .gff2, .gff, and .bedGraph
or .bdg. BED3 through BED6 files are supported under the .bed extension. Files
without these extensions are supported under the conditions that the first 3
columns correspond to 'chr', 'start', and 'end' and that there is either no
header column, or it is commented out. If a \code{data.frame} A BEDX+Y style
\code{data.frame}. See \code{GenomicRanges::makeGRangesFromDataFrame} for
acceptable column names.}

\item{genome}{One of the \code{supported_genomes()}.}
}
\value{
A trellis plot object.
}
\description{
Create a histogram of the distance from each peak to the nearest transcription
start site (TSS) of any gene.
}
\examples{

# Create histogram of distance from peaks to nearest TSS.
data(peaks_E2F4, package = 'chipenrich.data')
peaks_E2F4 = subset(peaks_E2F4, peaks_E2F4$chrom == 'chr1')
plot_dist_to_tss(peaks_E2F4, genome = 'hg19')

}
