% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSeqsAcrossBSJs.R
\name{getSeqsAcrossBSJs}
\alias{getSeqsAcrossBSJs}
\title{Retrieve back-spliced junction sequences}
\usage{
getSeqsAcrossBSJs(annotatedBSJs, gtf, genome)
}
\arguments{
\item{annotatedBSJs}{A data frame with the annotated back-spliced junctions.
It can be generated with \code{\link{annotateBSJs}}.}

\item{gtf}{A dataframe containing genome annotation information. It can be
generated with \code{\link{formatGTF}}.}

\item{genome}{A BSgenome object containing the genome sequences.
It can be generated with \code{\link{getBSgenome}}.
See \code{\link[BSgenome]{available.genomes}} to see the BSgenome package
currently available.}
}
\value{
A list.
}
\description{
The function getSeqsAcrossBSJs() retrieves
the sequences across the back-spliced junctions. A total of 11 nucleotides
from each side of the back-spliced junction are taken and concatenated
together.
}
\examples{
# Load a data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1, ], gtf)

# Get genome
if (requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)){

genome <- BSgenome::getBSgenome("BSgenome.Hsapiens.UCSC.hg19")

# Retrieve target sequences
targets <- getSeqsAcrossBSJs(
    annotatedBSJs,
    gtf,
    genome)
}


}
