% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFilesPredictionTool.R
\name{importCircMarker}
\alias{importCircMarker}
\title{Import circRNAs detected by CircMarker}
\usage{
importCircMarker(pathToFile, gtf)
}
\arguments{
\item{pathToFile}{A character string specifying the path to the file
containing the detected circRNAs.}

\item{gtf}{A data frame containing the formatted GTF file. This is generated
with \code{\link{formatGTF}}.}
}
\value{
A data frame.
}
\description{
The function importCircMarker is specifically designed to read
and adapt the CircMarker (July.24.2018) output file (Brief_sum.txt).
See \url{https://github.com/lxwgcool/CircMarker} for more details.
}
\examples{
# Load short version of the gencode v19 annotation file
data("gtf")

# Path to an example file containing circRNA detected by CircMarker
pathToFile <- system.file("extdata", "circmarker/circRNAs_001.txt",
    package="circRNAprofiler")

# Inner function.
# Import circRNAs.
# Due to the short version of the gtf file gene names might miss in the
# returned output.
importCircMarker(pathToFile, gtf)

}
\keyword{internal}
