% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_dplyr.R
\name{cor_to_call}
\alias{cor_to_call}
\title{get best calls for each cluster}
\usage{
cor_to_call(
  cor_mat,
  metadata = NULL,
  cluster_col = "cluster",
  collapse_to_cluster = FALSE,
  threshold = 0,
  rename_prefix = NULL,
  carry_r = FALSE
)
}
\arguments{
\item{cor_mat}{input similarity matrix}

\item{metadata}{input metadata with tsne or umap coordinates and cluster ids}

\item{cluster_col}{metadata column, can be cluster or cellid}

\item{collapse_to_cluster}{if a column name is provided, takes the most
frequent call of entire cluster to color in plot}

\item{threshold}{minimum correlation coefficent cutoff for calling clusters}

\item{rename_prefix}{prefix to add to type and r column names}

\item{carry_r}{whether to include threshold in unassigned names}
}
\value{
dataframe of cluster, new ident, and r info
}
\description{
get best calls for each cluster
}
\examples{
res <- clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    cluster_col = "classified",
    ref_mat = cbmc_ref
)

cor_to_call(res)
}
