% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment-visualization.R
\docType{methods}
\name{enrichMAplot}
\alias{enrichMAplot}
\alias{enrichMAplot,list-method}
\alias{enrichMAplot,AnnotatedDataFrame-method}
\title{MA plot of enriched annotations.}
\usage{
enrichMAplot(x, pvalue = "pvals", siglev = 0.05, size = 1,
  alpha = 1)

\S4method{enrichMAplot}{list}(x, pvalue = "pvals", siglev = 0.05,
  size = 1, alpha = 1)

\S4method{enrichMAplot}{AnnotatedDataFrame}(x, pvalue = "pvals",
  siglev = 0.05, size = 1, alpha = 1)
}
\arguments{
\item{x}{\code{AnnotatedDataFrame} object, or a list of those.}

\item{pvalue}{Character, one of \code{c("pvals", "padj")}.}

\item{siglev}{Numeric, significance level to be used for plotting.}

\item{size}{Numeric, size of points in plot.}

\item{alpha}{Numeric, between 0 and 1, indicating points' transparency.}
}
\value{
A \code{ggplot} object.
}
\description{
Make an MA-like plot of enriched annotations, similar to
the commonly used plots in differential expression analysis.
}
\examples{
require(ggplot2)

HD59_KO
enrichMAplot(HD59_KO)
enrichMAplot(HD59_KO, pvalue = "padj")
enrichMAplot(HD59_KO, siglev = 0.01)
enrichMAplot(HD59_KO, pvalue = "padj", siglev = 0.01)

x <- list(disease = LD94_KO, healthy = HD59_KO)
enrichMAplot(x)

}
