% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossTab-class.R
\docType{methods}
\name{reduceCrossTab}
\alias{reduceCrossTab}
\alias{reduceCrossTab,crossTab,character-method}
\title{Reduce \code{crossTab}.}
\usage{
reduceCrossTab(x, target)

\S4method{reduceCrossTab}{crossTab,character}(x, target)
}
\arguments{
\item{x}{A \code{crossTab} object to be reduced.}

\item{target}{Character vector indicating which onthology to use, either
\code{"pathway"} or \code{"module"}, or \code{"cogfunction"}.}
}
\value{
Returns input \code{crossTab} object, with updated contingency
   table, displaying new category values in rows, and updated counts
   in columns.
}
\description{
Reduce the input contingency table by associating sequences with
KEGG Pathway, KEGG Module or COG functional category identifiers.
}
\examples{
# create contingency table
s <- getKO(HD59)
v <- as.numeric(MELP(HD59, ribosomal = TRUE))
ct <- crossTab(s, v)
ct

# reduce contingency table
reduceCrossTab(ct, "pathway")
reduceCrossTab(ct, "module")

}
