% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estIndepModel.R
\name{estIndepModel}
\alias{estIndepModel}
\title{Estimate the independence model belonging to one view}
\usage{
estIndepModel(
  data,
  distribution,
  compositional,
  maxIt,
  tol,
  link,
  invLink,
  meanVarFit,
  newtonRaphson,
  dispFreq,
  ...
)
}
\arguments{
\item{data}{a list of data matrices with the same number of samples n in the rows.
Also phyloseq objects are acceptable}

\item{distribution}{a character string describing which distributional assumption should be used.}

\item{compositional}{A logical indicating if the dataset should be treated as compositional}

\item{maxIt}{an integer, the maximum number of iterations}

\item{tol}{A small scalar, the convergence tolerance}

\item{link, invLink}{link and inverse link function}

\item{meanVarFit}{mean variance model}

\item{newtonRaphson}{a boolean, should newton-raphson be used}

\item{dispFreq}{An integer, frequency of dispersion estimation}

\item{...}{passed on to the estOff() function}
}
\value{
A list with elements
\item{rowOff}{The row offsets}
\item{colOff}{The column offsets}
\item{converged}{A logical flag, indicating whether the fit converged}
\item{iter}{An integer, the number of iterations}
}
\description{
Estimate the independence model belonging to one view
}
