% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{phyloCompData-class}
\alias{phyloCompData-class}
\title{Class phyloCompData}
\description{
The \code{phyloCompData} class extends the \code{\linkS4class{compData}} class
with sequence length and phylogeny related information.
}
\section{Slots}{

\describe{
\item{\code{tree}:}{The phylogenetic tree describing the relationships between samples. The taxa names of the \code{tree} should be the same as the column names of the \code{count.matrix}. Class \code{phylo}.}
\item{\code{length.matrix}:}{The length matrix, with genes as rows and samples as columns. The column names of the \code{length.matrix} should be the same as the column names of the \code{count.matrix}. Class \code{matrix}.}
\item{\code{sample.annotations}:}{In addition to the columns described in the \code{\linkS4class{compData}} class, if the tree is specified, it should contain an extra column named \code{id.species} of factors giving the species for each sample. The row names should be the same as the column names of count.matrix. Class \code{data.frame}.}
}
}

\section{Methods}{

\describe{
\item{phylo.tree}{\code{signature(x="phyloCompData")}}
\item{phylo.tree<-}{\code{signature(x="phyloCompData",value="phylo")}:
Get or set the tree in a \code{phyloCompData} object. \code{value} should be a phylo object.}
\item{length.matrix}{\code{signature(x="phyloCompData")}}
\item{length.matrix<-}{\code{signature(x="phyloCompData",value="matrix")}:
Get or set the length matrix in a \code{phyloCompData} object. \code{value} should be a numeric matrix.}
}
}

\section{Construction}{

An object of the class \code{phyloCompData} can be constructed using the \code{\link{phyloCompData}} function.
}

\author{
Charlotte Soneson, Paul Bastide
}
