% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/progressionTest.R
\name{progressionTest}
\alias{progressionTest}
\alias{progressionTest,matrix-method}
\alias{progressionTest,SlingshotDataSet-method}
\alias{progressionTest,SingleCellExperiment-method}
\alias{progressionTest,PseudotimeOrdering-method}
\title{Differential Progression Test}
\usage{
progressionTest(pseudotime, ...)

\S4method{progressionTest}{matrix}(
  pseudotime,
  cellWeights,
  conditions,
  global = TRUE,
  lineages = FALSE,
  method = ifelse(dplyr::n_distinct(conditions) == 2, "KS", "Classifier"),
  thresh = ifelse(method == "Classifer", 0.05, 0.01),
  args_mmd = list(),
  args_classifier = list(),
  args_wass = list(),
  rep = 10000,
  distinct_samples = NULL
)

\S4method{progressionTest}{SlingshotDataSet}(
  pseudotime,
  conditions,
  global = TRUE,
  lineages = FALSE,
  method = ifelse(dplyr::n_distinct(conditions) == 2, "KS", "Classifier"),
  thresh = ifelse(method == "Classifer", 0.05, 0.01),
  args_mmd = list(),
  args_classifier = list(),
  args_wass = list(),
  rep = 10000,
  distinct_samples = NULL
)

\S4method{progressionTest}{SingleCellExperiment}(
  pseudotime,
  conditions,
  global = TRUE,
  lineages = FALSE,
  method = ifelse(dplyr::n_distinct(conditions) == 2, "KS", "Classifier"),
  thresh = ifelse(method == "Classifer", 0.05, 0.01),
  args_mmd = list(),
  args_classifier = list(),
  args_wass = list(),
  rep = 10000,
  distinct_samples = NULL
)

\S4method{progressionTest}{PseudotimeOrdering}(
  pseudotime,
  conditions,
  global = TRUE,
  lineages = FALSE,
  method = ifelse(dplyr::n_distinct(conditions) == 2, "KS", "Classifier"),
  thresh = ifelse(method == "Classifer", 0.05, 0.01),
  args_mmd = list(),
  args_classifier = list(),
  args_wass = list(),
  rep = 10000,
  distinct_samples = NULL
)
}
\arguments{
\item{pseudotime}{Can be either a \code{\link{SlingshotDataSet}} or a
\code{\link{SingleCellExperiment}} object or a matrix of pseudotime values,
each row represents a cell and each column represents a lineage.}

\item{...}{parameters including:}

\item{cellWeights}{If \code{pseudotime} is a matrix of pseudotime values, this
represent the cell weights for each lineage. Ignored if \code{pseudotime} is not
a matrix.}

\item{conditions}{Either the vector of conditions, or a character indicating
which column of the metadata contains this vector.}

\item{global}{If TRUE, test for all lineages simultaneously.}

\item{lineages}{If TRUE, test for all lineages independently.}

\item{method}{One of "KS", "Classifier", "mmd", "wasserstein_permutation" or
"Permutation" for a permutation. See details. Default to KS if there is two
conditions and to "Classifier" otherwise.}

\item{thresh}{The threshold for the KS test or Classifier test.
Ignored if \code{method = "Permutation"}. Default to .01 for KS and .05 for
the 'classifier'.}

\item{args_mmd}{arguments passed to the mmd test. See \code{\link{mmd_test}}.}

\item{args_classifier}{arguments passed to the classifier test. See \code{\link{classifier_test}}.}

\item{args_wass}{arguments passed to the wasserstein permutation test. See
\code{\link{wasserstein_permut}}.}

\item{rep}{Number of permutations to run. Only for methods "Permutations" and
"wasserstein_permutation". Default to \code{1e4}.}

\item{distinct_samples}{The samples to which each cell belong to. Only use
with method \code{distinct}. See \verb{\code{\link{distinct_test}}} for help.}
}
\value{
A data frame with 3 columns:
\itemize{
\item \emph{lineage} for individual lineages, the lineage number. For global,
\code{"All"}.
\item \emph{p.value} the pvalue for the test at the global or lineage level
\item \emph{statistic} for individual lineages, either the modified KS statistic
if \code{method = "KS"}, or the weighted difference of means, if
\code{method = "Permutation"}. For the global test, the combined Z-score.
}
}
\description{
Test whether or not the pseudotime distribution are identical
within lineages between conditions
}
\details{
For every lineage, we compare the pseudotimes of the cells from either
conditions, using the lineage weights as observations weights.
\itemize{
\item If \code{method = "KS"}, this uses the updated KS test,
see \code{\link{ks_test}} for details.
\item If \code{method = "Classifier"}, this uses a classifier to assess if
that classifier can do better than chance on the conditions
\item If \code{method = "Permutation"}, the difference of weighted mean
pseudotime between condition is computed, and a p-value is found by
permuting the condition labels.
\item If \code{method = "mmd"}, this uses the mean maximum discrepancies
statistics.
}
The p-value at the global level can be computed in two ways. method is \code{"KS"} or
\code{"Permutation"}, then the p-values are computed using stouffer's
z-score method, with the lineages weights acting as weights. Otherwise,
the test works on multivariate data and is applied on all pseudotime values.
}
\examples{
data('slingshotExample', package = "slingshot")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
condition <- factor(rep(c('A','B'), length.out = nrow(rd)))
condition[110:139] <- 'A'
sds <- slingshot::slingshot(rd, cl)
progressionTest(sds, condition)
}
\references{
Stouffer, S.A.; Suchman, E.A.; DeVinney, L.C.; Star, S.A.;
Williams, R.M. Jr. (1949).
\emph{The American Soldier, Vol.1: Adjustment during Army Life.}
Princeton University Press, Princeton.
}
