% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/slingshot_conditions.R
\name{slingshot_conditions}
\alias{slingshot_conditions}
\alias{slingshot_conditions,SlingshotDataSet-method}
\alias{slingshot_conditions,SingleCellExperiment-method}
\alias{slingshot_conditions,PseudotimeOrdering-method}
\title{Refitting slingshot per condition}
\usage{
slingshot_conditions(sds, ...)

\S4method{slingshot_conditions}{SlingshotDataSet}(
  sds,
  conditions,
  approx_points = 100,
  adjust_skeleton = TRUE,
  verbose = TRUE,
  ...
)

\S4method{slingshot_conditions}{SingleCellExperiment}(
  sds,
  conditions,
  approx_points = 100,
  adjust_skeleton = TRUE,
  verbose = TRUE,
  ...
)

\S4method{slingshot_conditions}{PseudotimeOrdering}(
  sds,
  conditions,
  approx_points = 100,
  adjust_skeleton = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{sds}{A slingshot object already run on the full dataset. Can be either a
\code{\link{SlingshotDataSet}} or a \code{\link{SingleCellExperiment}} object.}

\item{...}{Other arguments passed to \code{\link[slingshot]{getCurves}}}

\item{conditions}{Either the vector of conditions, or a character indicating which
column of the metadata contains this vector.}

\item{approx_points}{Passed to \code{\link[slingshot]{getCurves}}}

\item{adjust_skeleton}{Boolean, default to `TRUE`. Whether to recompute the locations
of the nodes after fitting per conditions.}

\item{verbose}{Boolean, default to `TRUE`. Control whether messages are printed.}
}
\value{
A list of \code{\link[slingshot]{SlingshotDataSet}}, one per condition.
}
\description{
Based on an original slingshot object, refit one trajectory per
condition, using the same skeleton.
}
\examples{
data('slingshotExample', package = "slingshot")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
condition <- factor(rep(c('A','B'), length.out = nrow(rd)))
condition[110:139] <- 'A'
sds <- slingshot::slingshot(rd, cl)
sdss <- slingshot_conditions(sds, condition)
}
